module.exports = function parse(parameters) {
  let result = {};
  for (let key in parameters) {
    let value = parameters[key];
    if (typeof value === 'string') {
      if (!isNaN(value)) {
        result[key] = Number(value);
      } else if (value.toLocaleLowerCase() === 'true') {
        result[key] = true;
      } else if (value.toLocaleLowerCase() === 'false') {
        result[key] = false;
      } else {
        result[key] = value;
      }
    }
  }
  return result;
};
